/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.logo.model;

import CH.ifa.draw.util.Storable;
import CH.ifa.draw.util.StorableInput;
import CH.ifa.draw.util.StorableOutput;
import DE.siemens.ad.logo.model.Block;
import DE.siemens.ad.logo.model.BlockParameter;
import DE.siemens.ad.logo.model.Hardware;
import DE.siemens.ad.logo.model.HardwareChangedEvent;
import DE.siemens.ad.logo.model.ParameterItem;
import DE.siemens.ad.logo.model.TimeUnit;
import DE.siemens.ad.logo.util.IntValueProperties;
import DE.siemens.ad.logo.util.ValueOrItemReference;
import java.io.IOException;
import java.io.Serializable;

public class IntegerOrBlockReference
implements ValueOrItemReference,
Serializable,
Storable {
    static final long serialVersionUID = 1L;
    private int serializedDataVersion = 1;
    protected IntValueProperties fIntValueProperties;
    private ParameterItem fReferenceItem;
    private BlockParameter fParameter;

    public IntegerOrBlockReference() {
    }

    public IntegerOrBlockReference(BlockParameter parameter) {
        this.fParameter = parameter;
    }

    private int getIntValue() {
        return this.fIntValueProperties.getCurrentValue();
    }

    public IntValueProperties getIntValueProperties() {
        if (this.fIntValueProperties == null) {
            this.fIntValueProperties = new IntValueProperties(0, 999999, 1, 0, "error.general", "Error in Input");
        }
        return this.fIntValueProperties;
    }

    public void setIntValueProperties(IntValueProperties intValueProperties) {
        this.fIntValueProperties = intValueProperties;
    }

    public IntegerOrBlockReference setIntValue(int intValue) {
        this.getIntValueProperties().setCurrentValue(intValue);
        this.setReference(null);
        return this;
    }

    public int getValue() {
        int result = 0;
        if (this.isReference()) {
            Object ref = this.getReference().getValue();
            if (ref instanceof IntValueProperties) {
                result = ((IntValueProperties)ref).getCurrentValue();
            } else if (ref instanceof Integer) {
                result = (Integer)ref;
            } else if (ref instanceof TimeUnit) {
                result = ((TimeUnit)ref).getReferencedValue();
            } else if (ref instanceof Double) {
                result = ((Double)ref).intValue();
            } else if (ref instanceof Long) {
                result = ((Long)ref).intValue();
            }
        } else {
            result = this.fIntValueProperties.getCurrentValue();
        }
        return result;
    }

    public int getValue(int minmum, int maximum) {
        int result = this.getValue();
        if (result < minmum) {
            return minmum;
        }
        if (result > maximum) {
            return maximum;
        }
        return result;
    }

    public void read(StorableInput dr) throws IOException {
        this.fIntValueProperties = (IntValueProperties)dr.readStorable();
        this.fReferenceItem = (ParameterItem)dr.readStorable();
        this.fParameter = (BlockParameter)dr.readStorable();
    }

    public void write(StorableOutput dw) {
        dw.writeStorable(this.fIntValueProperties);
        dw.writeStorable(this.fReferenceItem);
        dw.writeStorable(this.fParameter);
    }

    public boolean isReference() {
        return this.fReferenceItem != null;
    }

    public Block getReferenceToBlock() {
        return this.fReferenceItem.getParameter().getBlock();
    }

    public void setParameter(BlockParameter param) {
        this.fParameter = param;
    }

    public void setReference(ParameterItem reference) {
        this.fReferenceItem = reference;
    }

    public ParameterItem getReference() {
        return this.fReferenceItem;
    }

    public String getParameterText() {
        if (this.isReference()) {
            Block block = this.getReferenceToBlock();
            return block.getNumberPrefix() + Integer.toString(block.getNumber());
        }
        return String.valueOf(this.getIntValue());
    }

    public void hardwareChanged(HardwareChangedEvent hardwareChangedEvent) {
        Hardware newHw;
        Hardware oldHw = (Hardware)hardwareChangedEvent.getOldValue();
        if (oldHw != (newHw = (Hardware)hardwareChangedEvent.getNewValue()) && this.isReference()) {
            this.fReferenceItem = this.getReference().getParameter().getParameterItem(this.fReferenceItem.getIdentifier());
        }
    }

    public BlockParameter getParameter() {
        return this.fParameter;
    }

    public Object getDefaultDirectValue() {
        return new Integer(0);
    }

    public Object setDefaultDirectValue() {
        this.setIntValue(0);
        return this;
    }

    public void setValue(IntegerOrBlockReference newValue) {
        if (newValue.isReference()) {
            this.setReference(newValue.getReference());
        } else {
            this.setIntValue(newValue.getValue());
        }
    }
}

